﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NovelInterpreter.Interpreter.Enum;

namespace NovelInterpreter.Interpreter.Construction
{
	/// <summary>
	/// 構文の抽象クラス
	/// 文章も構文の一つとして解釈する
	/// </summary>
	public abstract class BaseConstruction
	{
		/// <summary>
		/// 構文名
		/// </summary>
		string constructionName;

		/// <summary>
		/// 構文名
		/// </summary>
		public string ConstructionName { get { return this.constructionName; } }

		/// <summary>
		/// 構文に渡された引数
		/// </summary>
		protected Dictionary<string, string> args;

		/// <summary>
		/// 構文番号
		/// </summary>
		int constructionNumber;

		/// <summary>
		/// 構文番号
		/// </summary>
		public int ConstructionNumber { get { return this.constructionNumber; } }
		
		/// <summary>
		/// 構文のコンストラクタ
		/// </summary>
		/// <param name="arguments">引数を表現した連想配列</param>
		public BaseConstruction(int constructionNumber, string constructionName, Dictionary<string, string> arguments)
		{
			this.constructionName = constructionName;
			this.args = arguments;
			this.constructionNumber = constructionNumber;
		}

		/// <summary>
		/// 構文を実行する
		/// </summary>
		public abstract InvokeResult Invoke(ConstructionContainer.Accessor accessor);

		/// <summary>
		/// 属性名からその値を取得する
		/// </summary>
		/// <param name="argName">属性名</param>
		/// <returns>属性の値</returns>
		public string GetArg(string argName)
		{
			return this.args[argName];
		}
	}
}
